#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/tsGGRy
//
// --------[ Original ShaderToy begins here ]---------- //

/* 
The next version of my audio shader
https://www.shadertoy.com/view/Wdy3DW - 202
https://www.shadertoy.com/view/wdGGzm - 201
https://www.shadertoy.com/view/WdG3zw - 104
https://www.shadertoy.com/view/WsyGRw - 103
https://www.shadertoy.com/view/wsKGzD - 102
https://www.shadertoy.com/view/3dV3zh - 101
This is MUCH simpler - each square is a halftone, each row is an octave
data pulled straight from the fft data
*/

#define TWO_PI 6.28318530718

#define C9 8372.02
#define Db9 8870.
#define D9 9398.
#define Eb9 9974.
#define E9 10548.
#define F9 11176.
#define Gb9 11840.
#define G9 12544.
#define Ab9 13290.
#define A9 14080.
#define Bb9 14918.
#define B9 15804.

float notes[] = float[](C9, Db9, D9,Eb9,E9,F9,Gb9,G9,Ab9,A9,Bb9,B9);

void mainImage( out vec4 O, vec2 u )
{
    vec2 U = u / iResolution.xy,
        to = U * vec2(12,10),
        TO = floor(to),
        D  =  abs(fract(to) - .5);

    float dist = max(D.x, D.y),
     frequency = notes[int(TO.x)] / exp2(9.-TO.y),
             f = texture(iChannel0, vec2(frequency/1e4,0)).r,
		bright = smoothstep(.0, .01 , (f*f*f*f)-dist*2. );
	
    O = bright * ( .6 + .6*cos( TWO_PI*(U.x-.15) + vec4(0,23,21,0)  ) );
}

/*
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    vec2 uv = fragCoord/iResolution.xy;
    
    float notes[12] = float[12](C9, Db9, D9,Eb9,E9,F9,Gb9,G9,Ab9,A9,Bb9,B9);
    
    int octave = int(floor(uv.y * 10.0));
    int semitone = int(floor(uv.x * 12.0));
    
    float disty = abs(fract(uv.y*10.0)-0.5);
    float distx = abs(fract(uv.x*12.0)-0.5);
    float dist = max(distx, disty);
 
    float frequency = notes[semitone]/pow(2.0, 9.0-float(octave));
    
    float freqv = texture(iChannel0, vec2(frequency/10000.,0.0)).r;
	freqv *=freqv;
    freqv *=freqv;
    float bright = step(dist*2.0, freqv);
	
    float c = 0.6;
    vec4 col = ( c + c*cos( TWO_PI*(uv.x-0.15) + vec4(0,23,21,0)  ) );
	fragColor = col*bright;
}
*/

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
