#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/4t33WX
//
// --------[ Original ShaderToy begins here ]---------- //

//Number of frequency bands
#define BANDS 30.0

//Number of colours - I think it looks best when equal to BANDS
#define SHADES 30.0

//Colour Scheme - possible values 1.0, 2.0, 3.0
#define C_SCHEME 3.0

float closeObj = 0.0;

vec2 mapMat(vec3 p){
    float sam = texture(iChannel0, vec2(floor((p.x + 1.0) * BANDS / 2.0) / BANDS, 0.0)).x;
    vec2 cylinder = vec2(length(p.yz) - sam, C_SCHEME);
    return cylinder;
}

float map(vec3 p){
    return mapMat(p).x;
}

float trace(vec3 ro, vec3 rd){
    float t = 0.0;
    float d = 0.0;
    vec2 c;
    int inter = 0;
    for(int i = 0; i < 1000; i++){
        c = mapMat(ro + rd * t);
        d = c.x;
        if(d < 0.0001){
            inter = 1;
            break;
        }
        t += d;
        if(t > 30.0){
            break;
        }
    }
    closeObj = c.y;
    if(inter == 0){
        t = -1.0;
    }
    return t;
}

vec3 normal(vec3 p){
    return normalize(vec3(map(vec3(p.x + 0.0001, p.yz)) - map(vec3(p.x - 0.0001, p.yz)),
                          map(vec3(p.x, p.y + 0.0001, p.z)) - map(vec3(p.x, p.y - 0.0001, p.z)),
                	      map(vec3(p.xy, p.z + 0.0001)) - map(vec3(p.xy, p.z - 0.0001))));
}

vec3 camPos = vec3(0.0, 0.0, 0.0);
vec3 lightPos = vec3(0.0, 0.0, 0.0);

vec3 amb(vec3 c, float k){
    return c * k;
}

vec3 diff(vec3 c, float k, vec3 p){
    vec3 n = normal(p);
    vec3 l = normalize(lightPos - p);
    return c * k * max(0.0, dot(n, l));
}

vec3 spec(vec3 c, float k, vec3 p, float a){
    vec3 n = normal(p);
    vec3 l = normalize(lightPos - p);
    vec3 v = normalize(p - camPos);
    float facing = dot(l, n) > 0.0 ? 1.0 : 0.0;
    vec3 r = reflect(l, n);
    return c * k * facing * pow(max(0.0, dot(r, v)), a);
}

vec3 colInterp(vec3 bcol, vec3 ecol, vec3 inCol){
    float st = 1.0 / SHADES;
    float avg = inCol.x * SHADES; 
    float band = ceil(avg) / SHADES;
    return mix(bcol, ecol, band);
}

vec3 palette(float id, vec3 inCol){
    if(id == 1.0){
        vec3 mcol = vec3(0.95);
        vec3 bcol = mcol / 4.0;
        return colInterp(bcol, mcol, inCol);
    }
    if(id == 2.0){
        vec3 mcol = vec3(1.0, 1.0, 0.0);
        vec3 bcol = vec3(0.0, 0.0, 1.0);
        return colInterp(bcol, mcol, inCol);
    }
    if(id == 3.0){
        vec3 mcol = vec3(1.0, 0.0, 0.0);
        vec3 bcol = vec3(0.0, 0.0, 1.0);
        return colInterp(bcol, mcol, inCol);
    }
    return vec3(0.0, 1.0, 0.0);
}

vec3 colour(vec3 p, float id){
    vec3 c = palette(id, vec3((p.x + 1.0) / 2.0));
    return diff(c, 0.75, p) + spec(c, 0.8, p, 8.0);
} 

void mainImage( out vec4 fragColor, in vec2 fragCoord ){
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    camPos = vec3(0.0 , 0.0, -2.0);
    lightPos = vec3(sin(iTime * 2.0) * 5.0, 0.0, -15.0);
    vec3 ro = camPos;
    vec3 rd = normalize(vec3(uv, 2.5));
    float d = trace(ro, rd);
    vec3 c = ro + rd * d;
    vec3 col = vec3(1.0);
    //If intersected
    if(d > 0.0){
    	col = colour(c, closeObj);
    	col *= 1.0 / exp(d * 0.1);
    }else{
        col = vec3(0.0);
    }
	fragColor = vec4(col,1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
