#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/4dXGWM
//
// --------[ Original ShaderToy begins here ]---------- //

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	
	vec2 uv = fragCoord.xy / iResolution.xy;
	
	vec3 color = vec3(0.0, 0.0, 0.0);
	float piikit  = texture(iChannel0, vec2(uv.x, 1.0)).r;
	
	float flash = texture(iChannel0, vec2(0.3, 0.0)).r;
	float glow = (0.01 + flash*0.02)/abs(piikit - uv.y);
	color = vec3(0.0, glow*0.5, glow);
	color += vec3(sqrt(glow*0.2));
	
	
	fragColor = vec4(color, 1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
