#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/XltSRj
//
// --------[ Original ShaderToy begins here ]---------- //

float gamma(float f) {
   return pow(f, 1. / 2.2); 
}

vec4 g3(vec4 col) {
    return vec4(gamma(col.r), gamma(col.g), gamma(col.b), 1.);
}

vec4 gradient(float y) {
    vec4 col1 = vec4(170. / 255., 170. / 255., 210. / 255., 1.);
    vec4 col2 = vec4(51. / 255., 153. / 255., 1., 1.);
    return g3(mix(col1, col2, y));
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = abs((fragCoord.xy / iResolution.xy - .5) * 2.);
    
    //float linear_interpolation = uv.x;
    //float log_interpolation = log2(1.0 + uv.x);
    float exp_interpolation = pow(uv.x, 2.);
    //float expB_interpolation = 1. - pow(1. - uv.x, 2.);
    
    float i = exp_interpolation;
    float fft_value = texture(iChannel0, vec2(i, 0.)).x;
	// fragColor = vec4(1. - step(fft_value, uv.y)) * gradient(uv.y);
    fragColor = abs(uv.y - fft_value) * gradient(uv.y) * fft_value;
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
