#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/slycW1
//
// --------[ Original ShaderToy begins here ]---------- //

#define xScale 1.0
#define yScale 0.4
#define barCount 20.0
#define barWidth 0.5
#define barHeight 0.2
#define clipWidth 0.9
#define curveDepth 0.4
#define reflectionDepth 0.25
#define reflectionHeight 0.6
#define yPos -0.1

float yOffset(float x)
{
    return sqrt(1.0-pow(max(0.0, x), 2.0));
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord/iResolution.xy - vec2(0.0, yPos);
    vec2 mouse = iMouse.xy/iResolution.xy;
    
    uv.x = abs(uv.x - 0.5)*3.0;

    
    float discreteX = floor(uv.x*barCount)/barCount;
    
    uv.y -= yOffset(abs(discreteX))*curveDepth;
    
    float height = texture(iChannel0, vec2(discreteX * xScale, 0.0)).x * yScale + barHeight;

    
    
    float intensity = 1.0;
    
    if(barHeight - uv.y > 0.0)
    {
        uv.y = abs(uv.y - barHeight) + curveDepth - reflectionDepth;
        height *= reflectionHeight;
        intensity = pow(1.0 - uv.y, 3.0);
    }
    
    fragColor = vec4(float(abs(mod(uv.x * barCount, 1.0) - 0.5) < barWidth * 0.5 && uv.y < height && uv.y > barHeight && uv.x < clipWidth)*intensity);
    //fragColor = vec4(1.0 - uv.yyy, 1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
