#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/4stfR8
//
// --------[ Original ShaderToy begins here ]---------- //

#define M_PI 3.14159265359

vec4 rectangle(vec4 color, vec4 background, vec4 region, vec2 uv);
vec2 rotate(vec2 point, vec2 center, float angle);
vec4 bar(vec4 color, vec4 background, vec2 position, vec2 diemensions, vec2 uv);
vec4 rays(vec4 color, vec4 background, vec2 position, float radius, float rays, sampler2D sound, vec2 uv);

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    //Prepare UV and background
    float aspect = iResolution.x / iResolution.y;
    vec2 uv = fragCoord/iResolution.xy;
    uv.x *= aspect;
    vec4 color = mix(vec4(1.0, 1.0, 0.2, 1.0), vec4(1.0, 0.5, 0.0, 1.0), distance(vec2(aspect/2.0, 0.5), uv));
    
    //VISUALIZER PARAMETERS
    const float RAYS = 96.0; //Please, decrease this value if shader is working too slow
    float RADIUS = 0.4;
    
    color = rays(vec4(1.0), color, vec2(aspect/2.0, 1.0/2.0), RADIUS, RAYS, iChannel0, uv);
    
    fragColor = color;
}

vec4 rays(vec4 color, vec4 background, vec2 position, float radius, float rays, sampler2D sound, vec2 uv)
{
    float inside = 0.8 * radius; //empty part of circle
    float outside = radius - inside; //rest of circle
    float circle = 2.0*M_PI*inside; //circle lenght
    for(int i = 1; float(i) <= rays; i++)
    {
        float len = outside * texture(sound, vec2(float(i)/rays, 0.0)).x + outside/10.0; //length of actual ray
        background = bar(color, background, vec2(position.x, position.y+inside), vec2(circle/(rays*2.0), len), rotate(uv, position, 360.0/rays*float(i))); //Draw 1 bar
    }
    return background; //output
}

vec4 bar(vec4 color, vec4 background, vec2 position, vec2 diemensions, vec2 uv)
{
    return rectangle(color, background, vec4(position.x, position.y+diemensions.y/2.0, diemensions.x/2.0, diemensions.y/2.0), uv); //Just transform rectangle a little
}

vec4 rectangle(vec4 color, vec4 background,  vec4 region, vec2 uv) //simple rectangle
{
    if(uv.x > (region.r-region.b) && uv.x < (region.r+region.b) &&
       uv.y > (region.g-region.a) && uv.y < (region.g+region.a))
    	return color;
    else return background;
}

vec2 rotate(vec2 point, vec2 center, float angle) //rotating point around center
{
    float s = sin(radians(angle));
    float c = cos(radians(angle));
    
    point.x -= center.x;
    point.y -= center.y;
    
    float x = point.x * c - point.y * s;
    float y = point.x * s + point.y * c;
    
    point.x = x + center.x;
    point.y = y + center.y;
    
    return point;
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
