#version 130

#ifdef GL_ES
precision mediump float;
#endif

// uniforms
uniform float time;
uniform vec2 resolution;
uniform vec2 mouse;
uniform sampler2D iChannel0;

// shadertoy emulation
#define iTime time
#define iResolution resolution
#define iMouse mouse

// --------[ Original ShaderToy begins here ]---------- //
//
// https://www.shadertoy.com/view/MtcSzr
//
// --------[ Original ShaderToy begins here ]---------- //

//Made by Matthew Dupree for fun. No credit, no profit.

//This shader creates a giant grid of white spheres through raytracing,
//which jump and shimmer according to the beat of the iChannel0 music track.
#define MAX_ITERATIONS 32

//Matrix generation function to
//rotate a given vector by theta.
mat2 rotation(float theta){
    float c = cos(theta);
    float s = sin(theta);
    return mat2(c, -s,
                s,  c);
}

//This map function defines the distance field for the raytracer
float map(vec3 p)
{
    //This function converts the single sphere I map into a
    //repeating grid that goes off into infinity.
    vec3 q = fract(p)*2.1 - 1.0;
    
    //This function defines the sphere (length(q)) and the radius
    //The radius is defined by one of the lower middle-range frequencies
    //of the audio track.
    //The brightness is handled elsewhere...
    return length(q) - (texture(iChannel0, vec2(0.21, 0.25)).x)/4.0;
}

//This is the raytracing function. It traces a ray as close as possible to some
//surface ahead of it in the map function.
//o is the origin of our search, r is the normalized ray we're looking along.
float trace(vec3 o, vec3 r){
    //Our current check distance.
    //Technically this calls one iteration before beginning the loop.
    float t = map(o)*0.5;
    
    //The tracing loop.
    for(int i = 0; i<MAX_ITERATIONS; i++){
        //First, get our current checking point.
        vec3 p = o + r * t;
        //Next, get the distance from this point
        //to the closest piece of geometry.
        float d = map(p);
        //If it's super tiny, we're close enough. Stop iterating.
        if(abs(d)<0.001) break;
        //Otherwise, get closer.
        t += d*0.5;
    }
    //Return the distance to the geometry.
    //(Whether we found any or not.)
    return t;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    //Establishing coordinate system, nothing fancy
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0; //Centering origin
    uv.x *= iResolution.x / iResolution.y; //Fixing aspect ratio
    
    //Pick a color for any rendered geometry. I went with white because... ehh...
    const vec3 fogColor = vec3(1.0,1.0,1.0);
    //This'll be our output color.
    vec3 ret = vec3(0.0);
    
    //Time modulo the track length. This allows the shader to loop.
    float time = mod(iTime, 258.07);
    
    //This is FOV control for the whole thing. 1.0 is 90 degree FOV, 0.0 is an infinite FOV.
    //The setup here starts the FOV at 0.0, then swings upward to 1.0 at 180 seconds.
    //At 180 seconds, it begins to swing back to 0.0, which it reaches at 240 seconds.
    float fov = smoothstep(0.0,180.0,time)*(1.0-smoothstep(180.0,240.0,time));
    
    //Generate our origin and facing vector. The origin flies through the grid as the video
    //goes along, the facing ray slowly spins. Fun!
    vec3 r = normalize(vec3(uv, fov));
    r.xz *= rotation(time/15.0);
    vec3 o = vec3(0.0, time/1.5, time/1.5);
    
    //Locate the geometry for this ray.
    float t = trace(o, r);
    //Calculate the brightness we should apply.
    //(How close is this geometry? Super close? 1.0)
    //(How close is this geometry? Super far? 0.0)
    float fog = 1.0 / (1.0 + t * t * 0.06);
    
    //Base drawing. Mix the background color with the fog color according to our brightness.
    ret = mix(ret, fogColor, fog);
    
    //Fade-in.
    //ret = mix(vec3(0.0), ret, smoothstep(0.0,5.0,time)*(1.0-smoothstep(250.0,254.0,time)));
    
    //Flashy lights.
    //This is what makes the brightness increase and decrease in time with the music.
    ret = mix(vec3(0.0), ret*2.0, (texture(iChannel0, vec2(0.01, 0.25)).x));
    
    //Output
	fragColor = vec4(ret, 1.0);
}

// --------[ Original ShaderToy ends here ]---------- //

void main(void)
{
    mainImage(gl_FragColor, gl_FragCoord.xy);
}
